  /******************************************************************************		
*                                                                                   	
*       Copyright (C) 2008 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       FLASH_DRV.C               											
*														              					
* Description:	  FLASH Driver file for MC9S08DZ60	        	    	
*                 based on Specification Rev. 3  	       						
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  FREESCALE CW COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM            *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/		

#include "flash_drv.h"
#include "sci_drv.h"

/******************************************************************************
Function Name	:	Mass_Erase_Routine
Parameters		:	NONE
Returns			  :	result
Notes			    : Erases entire flash array
******************************************************************************/
byte Mass_Erase(void) 
{
  byte result=FLASH_OK;

  if (FSTAT_FACCERR)        /* Check for access error */
  {                         
  FSTAT_FACCERR = 1;        /* Clear access error flag */
  }
  
  while (!FSTAT_FCBEF);     /* Wait here if command buffer is full */
  
  *((byte *) FLASH_START) = 0x67; /* Write to flash */
  
  FCMD = MASS_ERASE;        /* Write mass erase command */
  
  FSTAT_FCBEF = 1;          /* Write 1 to FCBEF to launch the command */
  
  asm
  {                         /* Wait 4 cycles */
  nop
  nop
  nop
  nop
  }
  
  if (FSTAT_FACCERR)        /* Check for access error */
  {                          
  FSTAT_FACCERR = 1;        /* Clear access error flag */
  result |= FLASH_FACCERR;  /* Set error code */
  }

  if (FSTAT_FPVIOL)
  {                         /* Check for protection violation */ 
  FSTAT_FPVIOL = 1;         /* Clear protection violation flag */
  result |= FLASH_FPVIOL;   /* Set error code */
  }
  
  while (!FSTAT_FCCF);      /* Wait for command to complete  */

  return result;
}

/******************************************************************************
Function Name	:	Sector_Erase_Routine
Parameters		:	*Addr
Returns			  :	result
Notes			    : Erases flash sector starting at 0xD000
******************************************************************************/
byte Sector_Erase(byte *Addr)
{
  byte result=FLASH_OK;

  if (FSTAT_FACCERR)        /* Check for access error */
  {                         
  FSTAT_FACCERR = 1;        /* Clear access error flag */
  }
  
  while (!FSTAT_FCBEF);     /* Wait here if command buffer is full */
  
  *Addr = 0x67;             /* Write to flash */
  
  FCMD = SECTOR_ERASE;      /* Write sector erase command */
  
  FSTAT_FCBEF = 1;          /* Write 1 to FCBEF to launch the command */
  
  asm
  {                         /* Wait 4 cycles */
  nop
  nop
  nop
  nop
  }
  
  if (FSTAT_FACCERR)        /* Check for access error */
  {                         
  FSTAT_FACCERR = 1;        /* Clear access error flag */
  result |= FLASH_FACCERR;  /* Set error code */
  }

  if (FSTAT_FPVIOL)
  {                         /* Check for protection violation */ 
  FSTAT_FPVIOL = 1;         /* Clear protection violation flag */
  result |= FLASH_FPVIOL;   /* Set error code */
  }
  
  while (!FSTAT_FCCF);      /* Wait for command to complete  */

  return result;
}

/******************************************************************************
Function Name	:	Sector_Erase_Abort_Routine
Parameters		:	NONE
Returns			  :	result
Notes			    :
******************************************************************************/
byte Sector_Erase_Abort(void)
{
  byte result=FLASH_OK;

  /* Begin sector erase procedure */
  if (FSTAT_FACCERR)        /* Check for access error */
  {                         
  FSTAT_FACCERR = 1;        /* Clear access error flag */
  }
  
  while (!FSTAT_FCBEF);     /* Wait here if command buffer is full */
  
  *((byte *) FLASH_START) = 0x67; /* Write to flash */
  
  FCMD = SECTOR_ERASE;      /* Write sector erase command */
  
  FSTAT_FCBEF = 1;          /* Write 1 to FCBEF to launch the command */
  
  asm
  {                         /* Wait 4 cycles */
  nop
  nop
  nop
  nop
  }
  
  /*  Customer should insert the delay that they require here prior to performing sector erase abort */ 

  if (!FSTAT_FCCF)          /* Check to see if command complete flag is clear */
  {                               
   *((byte *) FLASH_START) = 0x67; /* Write to flash */
  
    FCMD = SECTOR_ERASE_ABORT;   /* Write sector erase abort command */
  
    FSTAT_FCBEF = 1;        /* Write 1 to FCBEF to launch the command */
  
    asm
      {                     /* Wait 4 cycles */
      nop
      nop
      nop
      nop
      }
    
    while (!FSTAT_FCCF);    /* Wait for command to complete  */

    if (FSTAT_FACCERR)      /* Check for access error */
    {                               
     return result;         /* Return result */
    }
    else
    {
    result |= SECTOR_ERASED; /* Return result */
    }
  }
  else
  {
  result |= SECTOR_ERASED;  /* Return result */
  }
  
}

/******************************************************************************
Function Name	:	Byte_Programming_Routine
Parameters		:	*DestPtr, *SrcPtr, Length
Returns			  :	result
Notes			    :
******************************************************************************/
byte Byte_Program(byte *DestPtr, byte *SrcPtr, word Length)
{
  int i;
  byte result=FLASH_OK;
 
  if (FSTAT_FACCERR)        /* Check for access error */
  {                         
  FSTAT_FACCERR = 1;        /* Clear access error flag */
  }
  
  for (i = 0; ((i < Length) && (result == FLASH_OK)); i++)
  {
  while (!FSTAT_FCBEF);     /* Wait until command buffer is empty */
    
  *DestPtr++ = *SrcPtr++;
    
  FCMD = BYTE_PROGRAM;      /* Write byte program command */
  
  FSTAT_FCBEF = 1;          /* Write 1 to FCBEF to launch the command */

  asm
    {                       /* Wait 4 cycles */
    nop;
    nop;
    nop;
    nop;
    }

  if (FSTAT_FACCERR)        /* Check for access error */
    {                        
    FSTAT_FACCERR = 1;      /* Clear access error flag */
    result |= FLASH_FACCERR; /* Set error code */
    }

  if (FSTAT_FPVIOL)
    {                       /* Check for protection violation */ 
    FSTAT_FPVIOL = 1;       /* Clear protection violation flag */
    result |= FLASH_FPVIOL; /* Set error code */
    }
    
  while (!FSTAT_FCCF);      /* Wait for command to complete  */
  }

return result;
}

/******************************************************************************
Function Name	:	Blank_Check_Routine
Parameters		:	NONE
Returns			  :	result
Notes			    :
******************************************************************************/
byte Blank_Check(void)
{
  byte result=FLASH_OK;

  if (FSTAT_FACCERR)        /* Check for access error */
  {
  FSTAT_FACCERR = 1;        /* Clear access error flag */
  }
  
  while (!FSTAT_FCBEF);     /* Wait here until command buffer is empty */

  *((byte *) FLASH_START) = 0x67; /* Write to flash */
  
  FCMD = BLANK_CHECK;       /* Write blank check command */
  
  FSTAT_FCBEF = 1;          /* Write 1 to FCBEF to launch the command */
                         
  asm{                      /* Wait 4 cycles */
  nop
  nop
  nop
  nop
  }
  
  if (FSTAT_FACCERR)        /* Check for access error */
  {                             
  FSTAT_FACCERR = 1;        /* Clear access error flag */
  result |= FLASH_FACCERR;  /* Set error code */
  }
  
  if (FSTAT_FPVIOL)         /* Check for protection violation */
  {                         
  FSTAT_FPVIOL = 1;         /* Clear protection violation flag */
  result |= FLASH_FPVIOL;   /* Set error code */
  }
  while (!FSTAT_FCCF);      /* Wait for command to complete  */
  
  if (FSTAT_FBLANK)                   
  {
  result|=FLASH_BLANK;
  }
    
   return result;
}

/******************************************************************************
Function Name	:	Burst_Programming_Routine
Parameters		:	*DestPtr, *SrcPtr, Length
Returns			  :	result
Notes			    :
******************************************************************************/
byte Burst_Program(byte *DestPtr, byte *SrcPtr, word Length)
{
  byte result=FLASH_OK;
  int i;
  
  if (FSTAT_FACCERR)        /* Check for access error */
  {
  FSTAT_FACCERR = 1;        /* Clear access error flag */
  }
  
  for (i = 0; ((i < Length) && (result == FLASH_OK)); i++)
  {
  while (!FSTAT_FCBEF);

  *DestPtr++ = *SrcPtr++;

  FCMD = BURST_PROGRAM;     /* Write burst program command */

  FSTAT_FCBEF = 1;          /* Write 1 to FCBEF to launch the command */

  asm
  {                         /* Wait 4 cycles */
  nop;
  nop;
  nop;
  nop;
  }

  if (FSTAT_FACCERR)
  {                         /* Check for access error */
  FSTAT_FACCERR = 1;        /* Clear access error flag */
  result |= FLASH_FACCERR;  /* Set error code */
  }

  if (FSTAT_FPVIOL)
  {                         /* Check for protection violation */
  FSTAT_FPVIOL = 1;         /* Clear protection violation flag */
  result |= FLASH_FPVIOL;   /* Set error code */
  }  
  }
  while (!FSTAT_FCCF);      /* Wait for command to complete  */
  return result;
}


  

